{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 12.08.98 - 14:46:49 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMBmpLst, MMObj, MMHook, MMFill, MMBmpBtn, MMForm, ExtCtrls, MMPanel,
  MMDSPObj, MMWave;

type
  TForm1 = class(TForm)
    MMBitmapList1: TMMBitmapList;
    MMPanelFill1: TMMPanelFill;
    MMBitmapButton1: TMMBitmapButton;
    MMBitmapButton2: TMMBitmapButton;
    MMBitmapButton3: TMMBitmapButton;
    MMBitmapButton4: TMMBitmapButton;
    MMBitmapButton5: TMMBitmapButton;
    MMBitmapButton6: TMMBitmapButton;
    MemoryWave1: TMMMemoryWave;
    MemoryWave2: TMMMemoryWave;
    procedure MMBitmapButton1MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure MMBitmapButton6Click(Sender: TObject);
    procedure MMBitmapButton6MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure MMPanelFill1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MMPanelFill1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure MMPanelFill1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  public
    Dragging : Boolean;
    DragStart: TPoint;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TForm1.MMBitmapButton1MouseDown(Sender: TObject; Button: TMouseButton;
                                          Shift: TShiftState; X, Y: Integer);
begin
   MemoryWave1.PlaySound(pmAsync);
end;

{------------------------------------------------------------------------------}
procedure TForm1.MMBitmapButton6MouseDown(Sender: TObject; Button: TMouseButton;
                                          Shift: TShiftState; X, Y: Integer);
begin
   TMMBitmapButton(Sender).Down := True;
   TMMBitmapButton(Sender).Update;
   MemoryWave2.PlaySound(pmSync);
end;

{------------------------------------------------------------------------------}
procedure TForm1.MMBitmapButton6Click(Sender: TObject);
begin
   Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.MMPanelFill1MouseDown(Sender: TObject; Button: TMouseButton;
                                       Shift: TShiftState; X, Y: Integer);
begin
   if (Button = mbLeft) then
   begin
      Dragging := True;
      DragStart := TControl(Sender).ClientToScreen(Point(X,Y));
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.MMPanelFill1MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
var
   Diff: TPoint;
begin
   if Dragging then
   begin
      Diff := TControl(Sender).ClientToScreen(Point(X,Y));
      Diff := Point(Diff.X-DragStart.X,Diff.Y-DragStart.Y);
      SetBounds(Left+Diff.X,Top+Diff.Y,Width,Height);
      DragStart.X := DragStart.X+Diff.X;
      DragStart.Y := DragStart.Y+Diff.Y;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.MMPanelFill1MouseUp(Sender: TObject; Button: TMouseButton;
                                     Shift: TShiftState; X, Y: Integer);
begin
   if (Button = mbLeft) then Dragging := False;
end;

end.
